#include <stdio.h>
#include <sys/types.h>
#include <libusb.h>

static struct libusb_device_handle *dh;

int main(int argc,char *argv[]) {
  int r,ret,len;
  uint8_t data[1];
  if((ret=libusb_init(NULL))<0) return ret;
  if(NULL==(dh=libusb_open_device_with_vid_pid(NULL,0x6666,0x27c3))) {
    fprintf(stderr,"can't open vidpid 6666:27c3\n");
    goto done;
  }

  if(libusb_claim_interface(dh,0)<0) {
    fprintf(stderr,"can't claim interface 0\n");
    goto done;
  }

  do {
    r=libusb_interrupt_transfer(dh,0x81,data,sizeof(data),&len,10);
    if(LIBUSB_ERROR_TIMEOUT==r) {
      r=0;
      continue;
    } else if(r) {
      ret=1;
      printf("int_xfer=%d\n",r);
      goto release;
    }
    if(len<sizeof(data)) {
      printf("short: %d/%d\n",len,sizeof(data));
      continue;
    }
    printf("buttons=0x%02x\n",data[0]);
  } while(!r);

  ret=0;

release:
  libusb_release_interface(dh,0);
done:
  if(dh) libusb_close(dh);
  libusb_exit(NULL);
  return ret;
}
