#include "usb.h"
#include "usbcfg.h"
#include "usbdesc.h"

/* Please see USB 2.0 Specification Page 262 ff. */

const uint8_t USB_DeviceDescriptor[] = {
  USB_DEVICE_DESC_SIZE,              /* bLength */
  USB_DEVICE_DESCRIPTOR_TYPE,        /* bDescriptorType */
  WBVAL(0x0200), /* 2.0 */           /* bcdUSB */
  0xff,  /* bDeviceClass 0xff = vendor specific */
  0x00,                              /* bDeviceSubClass */
  0x00,                              /* bDeviceProtocol */
  USB_MAX_PACKET0,                   /* bMaxPacketSize0 */
  WBVAL(0x6666),                     /* idVendor */
  WBVAL(0x27c3),                     /* idProduct */
  WBVAL(0x0100), /* 1.00 */          /* bcdDevice */
  0x01,                              /* iManufacturer */
  0x02,                              /* iProduct */
  0x03,                              /* iSerialNumber */
  0x01                               /* bNumConfigurations: one possible configuration*/
};

const uint8_t USB_ConfigDescriptor[] = {
  9,
  USB_CONFIGURATION_DESCRIPTOR_TYPE,
  WBVAL(9+9+7),
  1,
  27,
  0,
  0x80, /* not self-powered, no remote wakeup */
  50,
  /* our first interface */
  9,
  USB_INTERFACE_DESCRIPTOR_TYPE,
  0,
  0,
  1,
  0xff,
  0xc3,
  0xff,
  0,
  /* our first endpoint */
  7,
  USB_ENDPOINT_DESCRIPTOR_TYPE,
  0x81,
  0x03,
  WBVAL(16),
  10
};



/* USB String Descriptor (optional) */
const uint8_t USB_StringDescriptor[] = {
/* Index 0x00: LANGID Codes */
  0x04,                              /* bLength */
  USB_STRING_DESCRIPTOR_TYPE,        /* bDescriptorType */
  WBVAL(0x0409), /* US English */    /* wLANGID */
/* Index 0x01: Manufacturer */
  (13*2 + 2),                        /* bLength (length + type + chars) */
  USB_STRING_DESCRIPTOR_TYPE,        /* bDescriptorType */
  'S',0,
  'a',0,
  'm',0,
  'p',0,
  'l',0,
  'e',0,
  ' ',0,
  'V',0,
  'e',0,
  'n',0,
  'd',0,
  'o',0,
  'r',0,
/* Index 0x02: Product */
  (12*2 + 2),                        /* bLength (length + type + chars) */
  USB_STRING_DESCRIPTOR_TYPE,        /* bDescriptorType */
  'P',0,
  'r',0,
  'o',0,
  'd',0,
  'u',0,
  'c',0,
  't',0,
  ' ',0,
  'N',0,
  'a',0,
  'm',0,
  'e',0,
/* Index 0x03: Serial Number */
  (12*2 + 2),                        /* bLength (length + type + chars) */
  USB_STRING_DESCRIPTOR_TYPE,        /* bDescriptorType */
  'D',0,
  'E',0,
  'M',0,
  'O',0,
  '0',0,
  '0',0,
  '0',0,
  '0',0,
  '0',0,
  '0',0,
  '0',0,
  '0',0,
/* Index 0x04: Interface 0, Alternate Setting 0 */
  ( 7*2 + 2),                        /* bLength (length + type + chars) */
  USB_STRING_DESCRIPTOR_TYPE,        /* bDescriptorType */
  'B',0,
  'u',0,
  't',0,
  't',0,
  'o',0,
  'n',0,
  's',0,
};
