_rom_start = ORIGIN(rom);
_rom_end   = ORIGIN(rom) + LENGTH(rom) - 1;
_ram_start = ORIGIN(ram);
_ram_end   = ORIGIN(ram) + LENGTH(ram) - 1;

SECTIONS
{
  .text :
  {
    _text = . ;
    _vector = . ;
    KEEP(*(.isr_vector))
    _evector = . ;

    _conf = . ;
    KEEP(*(.conf))
    KEEP(*(.conf.*))
    _econf = . ;

    /* NXP only CRP location */
    . = DEFINED(CRP_Key) ?  0x02FC : . ;
    KEEP (*(.CRP.*))
    . = ALIGN(4);

    KEEP (*(.text.handler.*))

    *(.text .text.* .gnu.linkonce.t.*)
    *(.plt)
    *(.gnu.warning)
    *(.glue_7t) *(.glue_7) *(.vfp11_veneer)

    *(.ARM.extab* .gnu.linkonce.armextab.*)
    *(.gcc_except_table)
  } >rom

  .eh_frame_hdr : ALIGN (4)
  {
    KEEP (*(.eh_frame_hdr))
  } >ram

  .eh_frame : ALIGN (4)
  {
    KEEP (*(.eh_frame))
  } >rom
  
  .rodata : ALIGN (4)
  {
    _rodata = .;
    *(.rodata .rodata.* .gnu.linkonce.r.*)
    _erodata = .;

    . = ALIGN(4);
    KEEP(*(.init))

    . = ALIGN(4);
    __preinit_array_start = .;
    KEEP (*(.preinit_array))
    __preinit_array_end = .;

    . = ALIGN(4);
    __init_array_start = .;
    KEEP (*(SORT(.init_array.*)))
    KEEP (*(.init_array))
    __init_array_end = .;

    . = ALIGN(4);
    KEEP(*(.fini))

    . = ALIGN(4);
    __fini_array_start = .;
    KEEP (*(.fini_array))
    KEEP (*(SORT(.fini_array.*)))
    __fini_array_end = .;

    . = ALIGN(4);
    KEEP (*crtbegin.o(.ctors))
    KEEP (*(EXCLUDE_FILE (*crtend.o) .ctors))
    KEEP (*(SORT(.ctors.*)))
    KEEP (*crtend.o(.ctors))

    . = ALIGN(4);
    KEEP (*crtbegin.o(.dtors))
    KEEP (*(EXCLUDE_FILE (*crtend.o) .dtors))
    KEEP (*(SORT(.dtors.*)))
    KEEP (*crtend.o(.dtors))

/*    . = ALIGN(8); */
    . = ALIGN(4);
    _eallrodata = .; 
  } >rom

  __exidx_start = .;
  .ARM.exidx :
  {
    *(.ARM.exidx* .gnu.linkonce.armexidx.*)
  } >rom
  __exidx_end = .; 

  . = ALIGN(8);
  _etext = .;
  _ldata = .;

  .data :  AT (_ldata)
  {
    _data = .;
   /* LOADADDR (.data); */
    KEEP(*(.jcr))
    *(.got.plt) *(.got)
    *(.shdata)
    *(.data .data.* .gnu.linkonce.d.*)
    . = ALIGN (8);
    *(.ram)
     
    _edata = .;
  } >ram

 _ledata = _ldata + SIZEOF(.data); 

  .bss :
  {
    _bss = .;
    *(.shbss)
    *(.bss .bss.* .gnu.linkonce.b.*)
    _ebss = .;
    *(COMMON)
    . = ALIGN(8);
    *(.ram.b)
  } >ram

  .heap :
  {
   . = ALIGN(8);
    _heap = .;
    *(.heap)
    _eheap = .;
  } >ram

  .stack :
  {
    . = ALIGN(8);
    _stack = .;
   *(.stack)
   
  } >ram

  . = _ram_end - 8;
  . = ALIGN(8);
  /* for compatibility */
  estack = .;
  _estack = .;
  . = _ram_end;
  _end = .;
   __end = .;
  
  .stab 0 (NOLOAD) : { *(.stab) }
  .stabstr 0 (NOLOAD) : { *(.stabstr) }
  /* DWARF debug sections.
   * Symbols in the DWARF debugging sections are relative to the beginning
   * of the section so we begin them at 0.  */
  /* DWARF 1 */
  .debug          0 : { *(.debug) }
  .line           0 : { *(.line) }
  /* GNU DWARF 1 extensions */
  .debug_srcinfo  0 : { *(.debug_srcinfo) }
  .debug_sfnames  0 : { *(.debug_sfnames) }
  /* DWARF 1.1 and DWARF 2 */
  .debug_aranges  0 : { *(.debug_aranges) }
  .debug_pubnames 0 : { *(.debug_pubnames) }
  /* DWARF 2 */
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }
  .debug_abbrev   0 : { *(.debug_abbrev) }
  .debug_line     0 : { *(.debug_line) }
  .debug_frame    0 : { *(.debug_frame) }
  .debug_str      0 : { *(.debug_str) }
  .debug_loc      0 : { *(.debug_loc) }
  .debug_macinfo  0 : { *(.debug_macinfo) }
  /* DWARF 2.1 */
  .debug_ranges   0 : { *(.debug_ranges) }
  /* SGI/MIPS DWARF 2 extensions */
  .debug_weaknames 0 : { *(.debug_weaknames) }
  .debug_funcnames 0 : { *(.debug_funcnames) }
  .debug_typenames 0 : { *(.debug_typenames) }
  .debug_varnames  0 : { *(.debug_varnames) }

  .note.gnu.arm.ident 0 : { KEEP (*(.note.gnu.arm.ident)) }
  .ARM.attributes 0 : { KEEP (*(.ARM.attributes)) }
  /DISCARD/ : { *(.note.GNU-stack) }
}
