#include <stdio.h>
#include <sys/types.h>
#include <libusb.h>

static struct libusb_device_handle *dh;

int main(int argc,char *argv[]) {
  int r,ret,len;
  uint8_t data[1];
  if((ret=libusb_init(NULL))<0) return ret;
  if(NULL==(dh=libusb_open_device_with_vid_pid(NULL,0x6666,0x27c3))) {
    fprintf(stderr,"can't open vidpid 6666:27c3\n");
    goto done;
  }

  r=libusb_control_transfer(dh,LIBUSB_REQUEST_TYPE_VENDOR|LIBUSB_RECIPIENT_DEVICE,0x00,0,0,NULL,0,1000);
  if(r) {
    ret=1;
    printf("ctrl_xfer=%d\n",r);
  }

  ret=0;

done:
  if(dh) libusb_close(dh);
  libusb_exit(NULL);
  return ret;
}
