#include "LPC13xx.h"
#include "usb.h"
#include "usbcfg.h"
#include "usbhw.h"
#include "usbcore.h"
#include "vendor.h"

uint8_t buttons() {
  uint32_t but1 = LPC_GPIO2->DATA & (1<<9);
  uint32_t but2 = LPC_GPIO1->DATA & (1<<4);
  uint8_t value=0;
  if(!but1)
    value|=1;
  if(!but2)
    value|=2;
  return value;
}

int main(void) {
  int i;
  uint8_t res, temp[15], buttonstate;

  SystemInit();
  USBIOClkConfig();
  USB_Init();
  USB_Connect(TRUE);
  while(!USB_Configuration);

  GPIOSetDir( 2, 9, 0 );
  GPIOSetDir( 1, 4, 0 );
  buttonstate = temp[0] = buttons();
  USB_WriteEP(0x81, temp, 1);

  /* leds */
  for(i=0;i<3;i++) {
    GPIOSetDir(3,i,1);
    GPIOSetValue(3,i,1);
  }

  while (1) {
    temp[0] = buttons();
    if(buttonstate!=temp[0]) {
      USB_WriteEP(0x81, temp, 1);
      buttonstate=temp[0];
    }
  }
}
