# -*- encoding: utf-8 -*-

from __future__ import unicode_literals
from flask import Flask, render_template, request, jsonify
import os, subprocess

app = Flask(__name__)

@app.route("/")
def hello():
	return render_template('index.html', foo=os.listdir('.'))

@app.route("/foo/<page_id>.html")
def mutat(page_id):
	return render_template('mutat.html', page_id=page_id)

@app.route("/scan", methods=['POST'])
def scan():
	output = subprocess.check_output(['ping', '-c', '1', request.form['ip']])
	return output

@app.route("/ls.json")
def ls():
	return jsonify(files=os.listdir('.'), p='Árvíztűrő')

if __name__ == '__main__':
	app.run(debug=True)
