package org.hsbp.hacksense;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.os.AsyncTask;
import android.content.Intent;
import java.net.URLConnection;
import java.net.URL;
import java.io.*;

public class Main extends Activity
{
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
    }

	public void megnyomtak(View view) {
		new AlertDialog.Builder(this)
			.setTitle(R.string.alert_title)
			.setMessage("Uzenet")
			.setNeutralButton("Bezar", null)
			.setPositiveButton("Action!",
					new DialogInterface.OnClickListener() {
						public void onClick(DialogInterface dialog,
								int which) {
							finish();
						}
					}
					)
			.show();
	}

	public void allapot(View view) {
		new AllapotTask().execute();
	}

	private class AllapotTask extends AsyncTask<Void, Void, String> {
		protected String doInBackground(Void... params) {
			try {
				URL url = new URL("http://vsza.hu/hacksense/status.txt");
				URLConnection urlConnection = url.openConnection();
				InputStream in = new BufferedInputStream(
					urlConnection.getInputStream());
				InputStreamReader isr = new InputStreamReader(in);
				BufferedReader br = new BufferedReader(isr);
				return br.readLine();
			} catch (Exception e) {}
			return null;
		}

		protected void onPostExecute(String result) {
			new AlertDialog.Builder(Main.this)
				.setMessage(result)
				.setNeutralButton("Bezar", null)
				.show();
		}
	}

	public void history(View view) {
		startActivity(new Intent(this, History.class));
	}
}
